<?php
include __DIR__ . '/../layout/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-building"></i> Tedarikçiler</h2>
    <a href="<?= BASE_URL ?>/suppliers/create" class="btn btn-primary">
        <i class="fas fa-plus"></i> Yeni Tedarikçi Ekle
    </a>
</div>

<!-- Özet Bilgiler -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card bg-primary text-white mb-3">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-building"></i> Toplam Tedarikçi</h6>
                <h3 class="mb-0"><?= $summary['total_suppliers'] ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-danger text-white mb-3">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-lira-sign"></i> Toplam Borç</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($summary['total_debt']) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-warning text-dark mb-3">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-exclamation-triangle"></i> Borçlu Tedarikçi</h6>
                <h3 class="mb-0"><?= $summary['suppliers_with_debt'] ?></h3>
            </div>
        </div>
    </div>
</div>


<?php
$flash = Helper::getFlash();
if ($flash):
?>
<div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
    <?= Helper::escape($flash['message']) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Arama ve Filtre Alanı -->
<div class="card glass-card mb-3">
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-4">
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-search"></i></span>
                    <input type="text" class="form-control" id="searchInput" placeholder="Tedarikçi ara...">
                </div>
            </div>
            <div class="col-md-3">
                <select class="form-select" id="sortSelect">
                    <option value="name-asc">İsim (A-Z)</option>
                    <option value="name-desc">İsim (Z-A)</option>
                    <option value="debt-desc">Borç (Yüksek → Düşük)</option>
                    <option value="debt-asc">Borç (Düşük → Yüksek)</option>
                </select>
            </div>
            <div class="col-md-3">
                <select class="form-select" id="debtFilter">
                    <option value="all">Tüm Tedarikçiler</option>
                    <option value="with-debt">Sadece Borcu Olanlar</option>
                    <option value="no-debt">Borcu Olmayanlar</option>
                </select>
            </div>
            <div class="col-md-2">
                <button class="btn btn-secondary w-100" id="resetBtn">
                    <i class="fas fa-redo"></i> Sıfırla
                </button>
            </div>
        </div>
    </div>
</div>

<div class="card glass-card">
    <div class="card-body">
        <?php if (empty($suppliers)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                Henüz tedarikçi kaydı bulunmuyor. <a href="<?= BASE_URL ?>/suppliers/create">Yeni tedarikçi ekleyin</a> veya
                <a href="<?= BASE_URL ?>/import">Excel'den içe aktarın</a>.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th><i class="fas fa-building"></i> Tedarikçi Adı</th>
                            <th class="text-end"><i class="fas fa-lira-sign"></i> Toplam Borç</th>
                            <th class="text-center"><i class="fas fa-list"></i> İşlem Sayısı</th>
                            <th><i class="fas fa-clock"></i> Son İşlem</th>
                            <th class="text-center"><i class="fas fa-cog"></i> İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($suppliers as $supplier): ?>
                            <tr class="supplier-row" data-name="<?= strtolower(Helper::escape($supplier['supplier_name'])) ?>"
                                data-debt="<?= $supplier['total_debt'] ?>">
                                <td>
                                    <strong><?= Helper::escape($supplier['supplier_name']) ?></strong>
                                </td>
                                <td class="text-end">
                                    <strong class="<?= $supplier['total_debt'] > 0 ? 'text-danger' : 'text-success' ?>">
                                        <?= Helper::formatMoney($supplier['total_debt']) ?>
                                    </strong>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-info">
                                        <?= $supplier['transaction_count'] ?> işlem
                                    </span>
                                </td>
                                <td>
                                    <?php if ($supplier['last_transaction_date']): ?>
                                        <?= Helper::formatDate($supplier['last_transaction_date']) ?>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <a href="<?= BASE_URL ?>/suppliers/view/<?= $supplier['id'] ?>" class="btn btn-sm btn-info"
                                        title="Detay">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?= BASE_URL ?>/suppliers/edit/<?= $supplier['id'] ?>"
                                        class="btn btn-sm btn-warning" title="Düzenle">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form method="POST" action="<?= BASE_URL ?>/suppliers/delete/<?= $supplier['id'] ?>"
                                        class="d-inline"
                                        onsubmit="return confirm('Bu tedarikçiyi silmek istediğinize emin misiniz? Tüm işlem geçmişi de silinecek!')">
                                        <button type="submit" class="btn btn-sm btn-danger" title="Sil">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const searchInput = document.getElementById('searchInput');
        const sortSelect = document.getElementById('sortSelect');
        const debtFilter = document.getElementById('debtFilter');
        const resetBtn = document.getElementById('resetBtn');
        const rows = Array.from(document.querySelectorAll('.supplier-row'));

        function applyFilters() {
            const searchTerm = searchInput.value.toLowerCase();
            const sortValue = sortSelect.value;
            const filterValue = debtFilter.value;

            // Filtreleme
            let visibleRows = rows.filter(row => {
                const name = row.dataset.name;
                const debt = parseFloat(row.dataset.debt);

                // Arama filtresi
                if (searchTerm && !name.includes(searchTerm)) return false;

                // Borç filtresi
                if (filterValue === 'with-debt' && debt <= 0) return false;
                if (filterValue === 'no-debt' && debt > 0) return false;

                return true;
            });

            // Sıralama
            visibleRows.sort((a, b) => {
                const aName = a.dataset.name;
                const bName = b.dataset.name;
                const aDebt = parseFloat(a.dataset.debt);
                const bDebt = parseFloat(b.dataset.debt);

                switch (sortValue) {
                    case 'name-asc': return aName.localeCompare(bName, 'tr');
                    case 'name-desc': return bName.localeCompare(aName, 'tr');
                    case 'debt-desc': return bDebt - aDebt;
                    case 'debt-asc': return aDebt - bDebt;
                    default: return 0;
                }
            });

            // DOM'u güncelle
            const tbody = rows[0]?.parentElement;
            if (tbody) {
                rows.forEach(row => row.style.display = 'none');
                visibleRows.forEach(row => {
                    row.style.display = '';
                    tbody.appendChild(row);
                });
            }
        }

        // Event listeners
        searchInput.addEventListener('input', applyFilters);
        sortSelect.addEventListener('change', applyFilters);
        debtFilter.addEventListener('change', applyFilters);
        resetBtn.addEventListener('click', () => {
            searchInput.value = '';
            sortSelect.value = 'name-asc';
            debtFilter.value = 'all';
            applyFilters();
        });

        // İlk yükleme
        applyFilters();
    });
</script>

<?php include __DIR__ . '/../layout/footer.php'; ?>