<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-plus-circle"></i> Yeni Tedarikçi Ekle</h2>
    <a href="<?= BASE_URL ?>/suppliers" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Geri Dön
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form action="<?= BASE_URL ?>/suppliers/store" method="POST">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="supplier_name" class="form-label">Tedarikçi Adı *</label>
                        <input type="text" class="form-control" id="supplier_name" name="supplier_name" required autofocus>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="invoice_number" class="form-label">Fatura No</label>
                        <input type="text" class="form-control" id="invoice_number" name="invoice_number">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="amount" class="form-label">Tutar (₺) *</label>
                        <input type="number" step="0.01" class="form-control" id="amount" name="amount" required>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="due_date" class="form-label">Vade Tarihi</label>
                        <input type="date" class="form-control" id="due_date" name="due_date">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="status" class="form-label">Durum</label>
                        <select class="form-select" id="status" name="status">
                            <option value="pending" selected>Beklemede</option>
                            <option value="paid">Ödendi</option>
                            <option value="overdue">Gecikmiş</option>
                            <option value="payment_requested">Ödeme Talep Edildi</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="payment_date" class="form-label">Ödeme Tarihi</label>
                        <input type="date" class="form-control" id="payment_date" name="payment_date">
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">Açıklama</label>
                <textarea class="form-control" id="description" name="description" rows="3"></textarea>
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Kaydet
                </button>
                <a href="<?= BASE_URL ?>/suppliers" class="btn btn-secondary">
                    <i class="fas fa-times"></i> İptal
                </a>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
