<?php include __DIR__ . '/../layout/header.php'; ?>

<h2><i class="fas fa-calendar-alt"></i> Aylık Ödemeler</h2>

<div class="card mt-3">
    <div class="card-body">
        <?php if (empty($payments)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                Henüz aylık ödeme kaydı bulunmuyor. <a href="<?= BASE_URL ?>/import">Excel'den içe aktarın</a>.
            </div>
        <?php else: ?>
            <table class="table">
                <thead>
                    <tr><th>Ödeme Adı</th><th>Kategori</th><th>Gün</th><th>Tahmini Tutar</th></tr>
                </thead>
                <tbody>
                    <?php foreach ($payments as $payment): ?>
                    <tr>
                        <td><?= Helper::escape($payment['payment_name']) ?></td>
                        <td><?= Helper::translateCategory($payment['category']) ?></td>
                        <td><?= $payment['payment_day'] ?></td>
                        <td><?= Helper::formatMoney($payment['estimated_amount'] ?? 0) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
