<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Dashboard' ?> - <?= APP_NAME ?></title>

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>

    <style>
        :root {
            --primary-color: #667eea;
            --secondary-color: #764ba2;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
        }
        .sidebar a {
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            padding: 12px 20px;
            display: block;
            transition: all 0.3s;
        }
        .sidebar a:hover, .sidebar a.active {
            color: white;
            background: rgba(255,255,255,0.1);
            padding-left: 30px;
        }
        .navbar-custom {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .card {
            border: none;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            border-radius: 10px;
        }
        .stat-card {
            padding: 20px;
            border-left: 4px solid;
        }
        .stat-card.info { border-color: #17a2b8; }
        .stat-card.warning { border-color: #ffc107; }
        .stat-card.danger { border-color: #dc3545; }
        .stat-card.success { border-color: #28a745; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-2 d-md-block sidebar p-0">
                <div class="p-3 text-center border-bottom border-light">
                    <h4><i class="fas fa-chart-line"></i> KESKA</h4>
                    <small>Mali Takip</small>
                </div>
                <div class="p-3">
                    <div class="mb-3">
                        <small class="text-uppercase opacity-75">Kullanıcı</small>
                        <div class="mt-1">
                            <strong><?= $auth->user()['full_name'] ?? 'Kullanıcı' ?></strong><br>
                            <small class="opacity-75"><?= $auth->user()['role'] ?? '' ?></small>
                        </div>
                    </div>
                </div>
                <hr class="border-light">
                <div class="nav flex-column">
                    <a href="<?= BASE_URL ?>/dashboard" class="<?= ($currentPage ?? '') == 'dashboard' ? 'active' : '' ?>">
                        <i class="fas fa-home me-2"></i> Ana Sayfa
                    </a>
                    <a href="<?= BASE_URL ?>/suppliers" class="<?= ($currentPage ?? '') == 'suppliers' ? 'active' : '' ?>">
                        <i class="fas fa-users me-2"></i> Tedarikçiler
                    </a>
                    <a href="<?= BASE_URL ?>/banks" class="<?= ($currentPage ?? '') == 'banks' ? 'active' : '' ?>">
                        <i class="fas fa-university me-2"></i> Bankalar
                    </a>
                    <a href="<?= BASE_URL ?>/credit-cards" class="<?= ($currentPage ?? '') == 'credit-cards' ? 'active' : '' ?>">
                        <i class="fas fa-credit-card me-2"></i> Kredi Kartları
                    </a>
                    <a href="<?= BASE_URL ?>/monthly-payments" class="<?= ($currentPage ?? '') == 'monthly-payments' ? 'active' : '' ?>">
                        <i class="fas fa-calendar-alt me-2"></i> Aylık Ödemeler
                    </a>
                    <a href="<?= BASE_URL ?>/calendar" class="<?= ($currentPage ?? '') == 'calendar' ? 'active' : '' ?>">
                        <i class="fas fa-calendar me-2"></i> Takvim
                    </a>
                    <a href="<?= BASE_URL ?>/all-payments" class="<?= ($currentPage ?? '') == 'all-payments' ? 'active' : '' ?>">
                        <i class="fas fa-list me-2"></i> Tüm Ödemeler
                    </a>
                    <a href="<?= BASE_URL ?>/import" class="<?= ($currentPage ?? '') == 'import' ? 'active' : '' ?>">
                        <i class="fas fa-file-excel me-2"></i> Excel İçe Aktar
                    </a>
                    <hr class="border-light">
                    <a href="<?= BASE_URL ?>/logout">
                        <i class="fas fa-sign-out-alt me-2"></i> Çıkış
                    </a>
                </div>
            </nav>

            <!-- Main Content -->
            <main class="col-md-10 ms-sm-auto px-md-4">
                <!-- Navbar -->
                <nav class="navbar navbar-expand-lg navbar-custom mb-4">
                    <div class="container-fluid">
                        <h5 class="mb-0"><?= $pageTitle ?? 'Dashboard' ?></h5>
                        <div class="ms-auto">
                            <span class="text-muted">
                                <i class="fas fa-calendar-day"></i>
                                <?= date('d.m.Y') ?>
                            </span>
                        </div>
                    </div>
                </nav>

                <?php
                $flash = Helper::getFlash();
                if ($flash):
                ?>
                <div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
                    <?= Helper::escape($flash['message']) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php endif; ?>
