<?php include __DIR__ . '/../layout/header.php'; ?>

<h2><i class="fas fa-file-excel"></i> Excel İçe Aktar</h2>

<?php
$flash = Helper::getFlash();
if ($flash):
?>
<div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
    <?= Helper::escape($flash['message']) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="fas fa-upload"></i> Excel Dosyası Yükle</h5>
            </div>
            <div class="card-body">
                <form action="<?= BASE_URL ?>/import/process" method="POST" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label for="excel_file" class="form-label">Excel Dosyası (.xlsx veya .xls)</label>
                        <input type="file" class="form-control" id="excel_file" name="excel_file" accept=".xlsx,.xls" required>
                        <small class="text-muted">Maksimum dosya boyutu: 20MB</small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">İçe Aktarılacak Veriler</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="import_suppliers" name="import_suppliers" checked>
                            <label class="form-check-label" for="import_suppliers">
                                Tedarikçi & Çek Takibi
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="import_banks" name="import_banks" checked>
                            <label class="form-check-label" for="import_banks">
                                Banka Takibi
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="import_cards" name="import_cards" checked>
                            <label class="form-check-label" for="import_cards">
                                Kredi Kartları
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="import_monthly" name="import_monthly" checked>
                            <label class="form-check-label" for="import_monthly">
                                Aylık Ödemeler
                            </label>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload"></i> Yükle ve İçe Aktar
                    </button>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="fas fa-info-circle"></i> Bilgi</h5>
            </div>
            <div class="card-body">
                <h6>Excel Formatı</h6>
                <p class="small">Excel dosyanız şu sayfalara sahip olmalıdır:</p>
                <ul class="small">
                    <li>Tedarikçi & Çek Takibi</li>
                    <li>Banka Takibi</li>
                    <li>Kredi Kartları</li>
                    <li>Aylık Ödemeler</li>
                </ul>

                <hr>

                <h6>Dikkat Edilecekler</h6>
                <ul class="small">
                    <li>Mevcut veriler silinmeyecek</li>
                    <li>Aynı kayıtlar tekrar eklenmeyecek</li>
                    <li>Tarih formatı: DD.MM.YYYY</li>
                    <li>Tutarlar Türk Lirası olarak</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
