<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-file-invoice-dollar"></i> Dönem Borcu Ekle:
        <?= Helper::escape($card['card_name']) ?>
    </h2>
    <a href="<?= BASE_URL ?>/credit-cards" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Geri Dön
    </a>
</div>

<div class="card glass-card">
    <div class="card-body">
        <form action="<?= BASE_URL ?>/credit-cards/store-statement/<?= $card['id'] ?>" method="POST">
            <div class="row g-3">
                <div class="col-md-6">
                    <label for="year" class="form-label">Yıl</label>
                    <select class="form-select" id="year" name="year" required>
                        <?php
                        $currentYear = date('Y');
                        for ($i = $currentYear; $i >= $currentYear - 2; $i--): ?>
                            <option value="<?= $i ?>">
                                <?= $i ?>
                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="month" class="form-label">Ay</label>
                    <select class="form-select" id="month" name="month" required>
                        <?php
                        $months = [
                            1 => 'Ocak',
                            2 => 'Şubat',
                            3 => 'Mart',
                            4 => 'Nisan',
                            5 => 'Mayıs',
                            6 => 'Haziran',
                            7 => 'Temmuz',
                            8 => 'Ağustos',
                            9 => 'Eylül',
                            10 => 'Ekim',
                            11 => 'Kasım',
                            12 => 'Aralık'
                        ];
                        $currentMonth = date('n');
                        foreach ($months as $num => $name): ?>
                            <option value="<?= $num ?>" <?= $num == $currentMonth ? 'selected' : '' ?>>
                                <?= $name ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="total_amount" class="form-label">Dönem Borcu</label>
                    <input type="number" step="0.01" class="form-control" id="total_amount" name="total_amount"
                        required>
                </div>
                <div class="col-md-6">
                    <label for="minimum_payment" class="form-label">Asgari Ödeme Tutarı</label>
                    <input type="number" step="0.01" class="form-control" id="minimum_payment" name="minimum_payment">
                    <div class="form-text">Boş bırakılırsa 0 kabul edilir.</div>
                </div>
                <div class="col-12">
                    <label for="notes" class="form-label">Notlar</label>
                    <textarea class="form-control" id="notes" name="notes" rows="2"></textarea>
                </div>

                <div class="col-12">
                    <div class="alert alert-warning d-flex align-items-center">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="update_current_debt"
                                name="update_current_debt" value="1" checked>
                            <label class="form-check-label" for="update_current_debt">
                                <strong>Kartın Güncel Borç Bilgisini Güncelle</strong>
                                <br>
                                <small>İşaretlenirse, girilen "Dönem Borcu" tutarı kartın "Mevcut Borç" hanesine
                                    yazılır.</small>
                            </label>
                        </div>
                    </div>
                </div>

                <div class="col-12 text-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Kaydet
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>