<?php include __DIR__ . '/../../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-edit"></i> KMH Hesabı Düzenle</h2>
    <a href="<?= BASE_URL ?>/banks/kmh" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Geri
    </a>
</div>

<?php
$flash = Helper::getFlash();
if ($flash):
?>
<div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
    <?= Helper::escape($flash['message']) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="card glass-card">
    <div class="card-body">
        <form method="POST" action="<?= BASE_URL ?>/banks/kmh/update/<?= $account['id'] ?>">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="bank_name" class="form-label">Banka Adı <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="bank_name" name="bank_name" required
                               value="<?= Helper::escape($account['bank_name']) ?>">
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="account_subtype" class="form-label">Alt Tip</label>
                        <input type="text" class="form-control" id="account_subtype" name="account_subtype"
                               value="<?= Helper::escape($account['account_subtype'] ?? '') ?>">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="limit_amount" class="form-label">Limit Tutarı (₺) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" class="form-control" id="limit_amount" name="limit_amount" required
                               value="<?= $account['limit_amount'] ?>">
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="used_amount" class="form-label">Kullanılan Tutar (₺)</label>
                        <input type="number" step="0.01" class="form-control" id="used_amount" name="used_amount"
                               value="<?= $account['used_amount'] ?>">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="status" class="form-label">Durum</label>
                        <select class="form-select" id="status" name="status">
                            <option value="BEKLEMEDE" <?= $account['status'] === 'BEKLEMEDE' ? 'selected' : '' ?>>BEKLEMEDE</option>
                            <option value="ÖDENDİ" <?= $account['status'] === 'ÖDENDİ' ? 'selected' : '' ?>>ÖDENDİ</option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="notes" class="form-label">Notlar</label>
                <textarea class="form-control" id="notes" name="notes" rows="3"><?= Helper::escape($account['notes'] ?? '') ?></textarea>
            </div>

            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                <a href="<?= BASE_URL ?>/banks/kmh" class="btn btn-secondary">
                    <i class="fas fa-times"></i> İptal
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Güncelle
                </button>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
