<?php include __DIR__ . '/../../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-calendar-check"></i> Banka Aylik Es Taksitli Krediler</h2>
    <div class="btn-group">
        <button class="btn btn-primary" data-bs-toggle="collapse" data-bs-target="#newLoanForm">
            <i class="fas fa-plus"></i> Yeni Kredi
        </button>
        <a href="<?= BASE_URL ?>/banks" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Geri
        </a>
    </div>
</div>

<!-- Ozet Kartlar -->
<div class="row mb-3">
    <div class="col-md-4">
        <div class="card glass-card bg-gradient-primary text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-money-bill-wave"></i> Toplam Kredi Tutari</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($summary['total_loan_amount'] ?? 0) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card glass-card bg-gradient-warning text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-calendar-day"></i> Toplam Aylik Odeme</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($summary['total_monthly_payment'] ?? 0) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card glass-card bg-gradient-info text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-list"></i> Kredi Sayisi</h6>
                <h3 class="mb-0"><?= $summary['loan_count'] ?? 0 ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="collapse mb-3" id="newLoanForm">
    <div class="card glass-card">
        <div class="card-header bg-light">
            <strong><i class="fas fa-plus-circle"></i> Yeni Taksitli Kredi Ekle</strong>
        </div>
        <div class="card-body">
            <form method="POST" action="<?= BASE_URL ?>/banks/installment-loans/store">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Banka</label>
                        <input type="text" name="bank_name" class="form-control" required>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Kredi Tutari</label>
                        <input type="number" step="0.01" min="0" name="loan_amount" class="form-control" required>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Aylik Taksit</label>
                        <input type="number" step="0.01" min="0" name="monthly_payment" class="form-control" required>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Odeme Gunu</label>
                        <input type="number" min="1" max="31" name="payment_day" class="form-control" required>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Toplam Taksit</label>
                        <input type="number" min="1" name="total_installments" class="form-control" required>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Baslangic Tarihi</label>
                        <input type="date" name="start_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
                    </div>
                    <div class="col-md-9">
                        <label class="form-label">Not</label>
                        <input type="text" name="description" class="form-control" placeholder="Opsiyonel not...">
                    </div>
                    <div class="col-12 text-end">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save"></i> Kaydet
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="card glass-card">
    <div class="card-body">
        <?php if (empty($loans)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                Henüz taksitli kredi kaydı bulunmuyor.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th><i class="fas fa-university"></i> Banka</th>
                            <th class="text-end"><i class="fas fa-lira-sign"></i> Kredi Tutari</th>
                            <th class="text-center"><i class="fas fa-calendar"></i> Odeme Gunu</th>
                            <th class="text-end"><i class="fas fa-wallet"></i> Aylik Taksit</th>
                            <th class="text-center"><i class="fas fa-layer-group"></i> Kalan Taksit</th>
                            <th class="text-center"><i class="fas fa-clock"></i> Sonraki</th>
                            <th class="text-center"><i class="fas fa-check-circle"></i> Durum</th>
                            <th class="text-center"><i class="fas fa-cogs"></i> Islem</th>
                            <th><i class="fas fa-sticky-note"></i> Not</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($loans as $loan): ?>
                            <tr>
                                <td><strong><?= Helper::escape($loan['bank_name']) ?></strong></td>
                                <td class="text-end"><?= Helper::formatMoney($loan['loan_amount']) ?></td>
                                <td class="text-center">
                                    <span class="badge bg-secondary"><?= intval($loan['payment_day']) ?></span>
                                </td>
                                <td class="text-end">
                                    <strong class="text-primary"><?= Helper::formatMoney($loan['monthly_payment']) ?></strong>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-dark">
                                        <?= intval($loan['remaining_installments']) ?>/<?= intval($loan['total_installments']) ?>
                                    </span>
                                </td>
                                <td class="text-center">
                                    <?= Helper::formatDate($loan['next_payment_date']) ?>
                                    <?php if (!empty($loan['next_payment_number'])): ?>
                                        <br><small class="text-muted">#<?= intval($loan['next_payment_number']) ?></small>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php if (($loan['status'] ?? '') === 'TAMAMLANDI'): ?>
                                        <span class="badge bg-success">TAMAMLANDI</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark"><?= Helper::escape($loan['status'] ?? 'DEVAM EDİYOR') ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm">
                                        <button
                                            type="button"
                                            class="btn btn-warning edit-loan-btn"
                                            data-bs-toggle="modal"
                                            data-bs-target="#editLoanModal"
                                            data-loan-id="<?= intval($loan['id']) ?>"
                                            data-bank-name="<?= Helper::escape($loan['bank_name']) ?>"
                                            data-loan-amount="<?= $loan['loan_amount'] ?>"
                                            data-monthly-payment="<?= $loan['monthly_payment'] ?>"
                                            data-payment-day="<?= intval($loan['payment_day']) ?>"
                                            data-total-installments="<?= intval($loan['total_installments']) ?>"
                                            data-start-date="<?= Helper::escape($loan['start_date']) ?>"
                                            data-description="<?= Helper::escape($loan['description'] ?? '') ?>"
                                            title="Düzenle">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <?php if (!empty($loan['next_payment_id']) && ($loan['status'] ?? '') !== 'TAMAMLANDI'): ?>
                                            <form method="POST" action="<?= BASE_URL ?>/banks/installment-loans/mark-paid/<?= $loan['id'] ?>/<?= $loan['next_payment_id'] ?>">
                                                <button type="submit" class="btn btn-success" title="Siradaki taksidi odendi yap">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                        <button type="button" class="btn btn-outline-info" data-bs-toggle="collapse" data-bs-target="#payments<?= $loan['id'] ?>" title="Taksit gecmisi">
                                            <i class="fas fa-list"></i>
                                        </button>
                                        <form method="POST" action="<?= BASE_URL ?>/banks/installment-loans/delete/<?= $loan['id'] ?>" onsubmit="return confirm('Bu kredi kaydini silmek istediginize emin misiniz?')">
                                            <button type="submit" class="btn btn-danger" title="Sil">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                                <td><?= Helper::escape($loan['description'] ?? '-') ?></td>
                            </tr>
                            <tr>
                                <td colspan="9" class="py-0 border-0">
                                    <div class="collapse" id="payments<?= $loan['id'] ?>">
                                        <div class="p-3 bg-light border rounded mt-2 mb-2">
                                            <strong><i class="fas fa-receipt"></i> Taksit Gecmisi</strong>
                                            <div class="table-responsive mt-2">
                                                <table class="table table-sm mb-0">
                                                    <thead>
                                                        <tr>
                                                            <th>No</th>
                                                            <th>Tarih</th>
                                                            <th class="text-end">Tutar</th>
                                                            <th>Durum</th>
                                                            <th>Odenme Tarihi</th>
                                                            <th>Islem</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php
                                                        $loanPayments = $paymentMap[(int)$loan['id']] ?? [];
                                                        if (empty($loanPayments)):
                                                        ?>
                                                            <tr>
                                                                <td colspan="6" class="text-muted">Taksit kaydi bulunamadi.</td>
                                                            </tr>
                                                        <?php else: ?>
                                                            <?php foreach ($loanPayments as $payment): ?>
                                                                <tr>
                                                                    <td>#<?= intval($payment['payment_number']) ?></td>
                                                                    <td><?= Helper::formatDate($payment['payment_date']) ?></td>
                                                                    <td class="text-end"><?= Helper::formatMoney($payment['amount']) ?></td>
                                                                    <td>
                                                                        <?php if (($payment['status'] ?? '') === 'ÖDENDİ'): ?>
                                                                            <span class="badge bg-success">ÖDENDİ</span>
                                                                        <?php else: ?>
                                                                            <span class="badge bg-warning text-dark">BEKLEMEDE</span>
                                                                        <?php endif; ?>
                                                                    </td>
                                                                    <td><?= !empty($payment['paid_date']) ? Helper::formatDate($payment['paid_date']) : '-' ?></td>
                                                                    <td>
                                                                        <?php if (($payment['status'] ?? '') === 'BEKLEMEDE'): ?>
                                                                            <form method="POST" action="<?= BASE_URL ?>/banks/installment-loans/mark-paid/<?= $loan['id'] ?>/<?= $payment['id'] ?>" class="d-inline">
                                                                                <button type="submit" class="btn btn-sm btn-success">Ödendi</button>
                                                                            </form>
                                                                        <?php else: ?>
                                                                            <form method="POST" action="<?= BASE_URL ?>/banks/installment-loans/mark-pending/<?= $loan['id'] ?>/<?= $payment['id'] ?>" class="d-inline">
                                                                                <button type="submit" class="btn btn-sm btn-outline-secondary">Geri Al</button>
                                                                            </form>
                                                                        <?php endif; ?>
                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; ?>
                                                        <?php endif; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="modal fade" id="editLoanModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-edit"></i> Krediyi Duzenle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" id="editLoanForm">
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">Banka</label>
                            <input type="text" name="bank_name" id="editBankName" class="form-control" required>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Kredi Tutari</label>
                            <input type="number" step="0.01" min="0" name="loan_amount" id="editLoanAmount" class="form-control" required>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Aylik Taksit</label>
                            <input type="number" step="0.01" min="0" name="monthly_payment" id="editMonthlyPayment" class="form-control" required>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Odeme Gunu</label>
                            <input type="number" min="1" max="31" name="payment_day" id="editPaymentDay" class="form-control" required>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Toplam Taksit</label>
                            <input type="number" min="1" name="total_installments" id="editTotalInstallments" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Baslangic Tarihi</label>
                            <input type="date" name="start_date" id="editStartDate" class="form-control" required>
                        </div>
                        <div class="col-md-8">
                            <label class="form-label">Not</label>
                            <input type="text" name="description" id="editDescription" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Iptal</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Guncelle
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const editForm = document.getElementById('editLoanForm');
    const editButtons = document.querySelectorAll('.edit-loan-btn');

    editButtons.forEach(function (button) {
        button.addEventListener('click', function () {
            const loanId = button.getAttribute('data-loan-id');
            editForm.action = '<?= BASE_URL ?>/banks/installment-loans/update/' + loanId;

            document.getElementById('editBankName').value = button.getAttribute('data-bank-name') || '';
            document.getElementById('editLoanAmount').value = button.getAttribute('data-loan-amount') || '0';
            document.getElementById('editMonthlyPayment').value = button.getAttribute('data-monthly-payment') || '0';
            document.getElementById('editPaymentDay').value = button.getAttribute('data-payment-day') || '1';
            document.getElementById('editTotalInstallments').value = button.getAttribute('data-total-installments') || '1';
            document.getElementById('editStartDate').value = button.getAttribute('data-start-date') || '';
            document.getElementById('editDescription').value = button.getAttribute('data-description') || '';
        });
    });
});
</script>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
