<?php include __DIR__ . '/../layout/header.php'; ?>

<h2><i class="fas fa-list"></i> Tüm Ödemeler</h2>

<div class="card mt-3">
    <div class="card-body">
        <?php if (empty($payments)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                Henüz ödeme kaydı bulunmuyor. <a href="<?= BASE_URL ?>/import">Excel'den içe aktarın</a>.
            </div>
        <?php else: ?>
            <table class="table table-sm">
                <thead>
                    <tr><th>Tarih</th><th>Kaynak</th><th>Açıklama</th><th>Tutar</th><th>Durum</th></tr>
                </thead>
                <tbody>
                    <?php foreach ($payments as $payment): ?>
                    <tr>
                        <td><?= Helper::formatDate($payment['payment_date']) ?></td>
                        <td><span class="badge bg-secondary"><?= $payment['source'] ?></span></td>
                        <td><?= Helper::escape($payment['description'] ?? $payment['payment_name']) ?></td>
                        <td><?= Helper::formatMoney($payment['amount']) ?></td>
                        <td><span class="badge bg-<?= Helper::getStatusBadge($payment['status']) ?>"><?= Helper::translateStatus($payment['status']) ?></span></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
