-- ============================================================================
-- BCH ve Aylik Es Taksitli Kredi Verisi Yukleme
-- Tarih: 2026-02-10
-- ============================================================================
-- Bu script SADECE:
--   1) bank_bch
--   2) bank_installment_loans (+ bagli bank_installment_payments)
-- tablolarini gunceller.
-- ============================================================================

START TRANSACTION;

-- --------------------------------------------------------------------------
-- BCH (Banka BCH Borclari)
-- --------------------------------------------------------------------------
DELETE FROM bank_bch;

INSERT INTO bank_bch (bank_name, amount, due_date, status, payment_date, description)
VALUES
('ZIRAAT BANK-BCH', 0.00, '2026-02-10', 'ÖDEME', '2026-02-10', '300 bin odendi KMH lar ile'),
('AKBANK-BCH', 350000.00, '2026-02-18', 'BEKLEMEDE', NULL, NULL),
('ZIRAAT BANK-BCH', 200000.00, '2026-04-17', 'BEKLEMEDE', NULL, NULL),
('HALK BANK-BCH', 300000.00, '2026-05-07', 'BEKLEMEDE', NULL, NULL),
('HALK BANK-BCH', 500000.00, '2026-05-26', 'BEKLEMEDE', NULL, NULL),
('ZIRAAT BANK-BCH', 100000.00, '2026-05-26', 'BEKLEMEDE', NULL, NULL),
('HALK BANK-BCH', 575000.00, '2026-06-05', 'BEKLEMEDE', NULL, NULL),
('ZIRAAT BANK-BCH', 100000.00, '2026-06-12', 'BEKLEMEDE', NULL, NULL),
('AKBANK-BCH', 350000.00, '2026-06-13', 'BEKLEMEDE', NULL, NULL);

-- --------------------------------------------------------------------------
-- Aylik Es Taksitli Kredi Borclari
-- --------------------------------------------------------------------------
DELETE FROM bank_installment_payments;
DELETE FROM bank_installment_loans;

INSERT INTO bank_installment_loans (
    bank_name,
    loan_amount,
    monthly_payment,
    total_installments,
    remaining_installments,
    start_date,
    next_payment_date,
    status,
    description
)
VALUES
('GARANTI BANK', 500000.00, 35427.77, 1, 1, '2026-01-01', '2026-03-01', 'DEVAM EDİYOR', 'Odeme gunu: 1'),
('IS BANKASI', 600000.00, 63251.77, 1, 1, '2026-01-01', '2026-03-17', 'DEVAM EDİYOR', 'Odeme gunu: 17'),
('ZIRAAT BANK', 500000.00, 59106.73, 1, 1, '2026-01-01', '2026-03-20', 'DEVAM EDİYOR', 'Odeme gunu: 20'),
('HALK BANKASI', 850000.00, 56896.20, 1, 1, '2026-01-01', '2026-03-05', 'DEVAM EDİYOR', 'Odeme gunu: 5'),
('YAPI KREDI', 500000.00, 31398.79, 1, 1, '2026-01-01', '2026-03-19', 'DEVAM EDİYOR', 'Odeme gunu: 19'),
('ZIRAAT BANK', 500000.00, 57783.21, 1, 1, '2026-01-01', '2026-03-10', 'DEVAM EDİYOR', 'Odeme gunu: 10');

INSERT INTO bank_installment_payments (loan_id, payment_number, payment_date, amount, status)
SELECT id, 1, next_payment_date, monthly_payment, 'BEKLEMEDE'
FROM bank_installment_loans;

COMMIT;

-- Kontrol toplamlari:
-- BCH beklemede toplam: 2,475,000.00
-- Taksitli kredi toplam kredi tutari: 3,450,000.00
-- Taksitli kredi aylik odeme toplami: 303,864.47
