<?php
/**
 * Tek Seferlik Migration Script
 * Mevcut suppliers tablosundaki amount değerlerini supplier_transactions'a aktarır
 *
 * Çalıştırma: http://localhost/KRMuhasebe/public/migrate-supplier-amounts.php
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/Auth.php';

$db = Database::getInstance();
$auth = new Auth();

// Get admin user ID for created_by
$adminUser = $db->selectOne("SELECT id FROM users WHERE role = 'admin' LIMIT 1");
$createdBy = $adminUser['id'] ?? 1;

// Fetch all suppliers with amount > 0
$suppliers = $db->select("SELECT id, supplier_name, amount, due_date, invoice_number, created_at FROM suppliers WHERE amount > 0");

$migratedCount = 0;
$errors = [];

echo "<!DOCTYPE html>";
echo "<html><head><meta charset='UTF-8'><title>Supplier Migration</title>";
echo "<style>body{font-family:Arial;padding:20px;} .success{color:green;} .error{color:red;} .summary{background:#f0f0f0;padding:15px;margin-top:20px;border-radius:5px;}</style>";
echo "</head><body>";
echo "<h1>Tedarikçi Borç Migration İşlemi</h1>";
echo "<p>Toplam " . count($suppliers) . " tedarikçi kaydı bulundu (amount > 0)</p><hr>";

foreach ($suppliers as $supplier) {
    // Insert initial purchase transaction
    $transactionData = [
        'supplier_id' => $supplier['id'],
        'transaction_type' => 'purchase',
        'amount' => $supplier['amount'],
        'transaction_date' => $supplier['due_date'] ?? date('Y-m-d'),
        'reference_number' => $supplier['invoice_number'],
        'description' => 'İlk borç kaydı (otomatik migration)',
        'created_by' => $createdBy
    ];

    $result = $db->insert('supplier_transactions', $transactionData);

    if ($result) {
        $migratedCount++;
        echo "<div class='success'>✓ <strong>{$supplier['supplier_name']}</strong>: " . number_format($supplier['amount'], 2) . " TL → supplier_transactions'a aktarıldı</div>";
    } else {
        $errors[] = $supplier['supplier_name'];
        echo "<div class='error'>✗ <strong>{$supplier['supplier_name']}</strong>: HATA - İşlem başarısız!</div>";
    }
}

echo "<div class='summary'>";
echo "<h2>Migration Özeti</h2>";
echo "<p><strong>Başarılı:</strong> {$migratedCount} kayıt</p>";
echo "<p><strong>Hatalı:</strong> " . count($errors) . " kayıt</p>";

if (count($errors) > 0) {
    echo "<p style='color:red'><strong>Hatalar:</strong> " . implode(', ', $errors) . "</p>";
} else {
    echo "<p style='color:green'><strong>✓ Tüm kayıtlar başarıyla aktarıldı!</strong></p>";
}

echo "<p style='margin-top:20px;'><a href='" . BASE_URL . "/suppliers' style='background:#4F46E5;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>Tedarikçiler Sayfasına Git</a></p>";
echo "</div>";

echo "</body></html>";
