<?php
/**
 * Migration Script: Add account_category to bank_transactions
 *
 * Usage: http://localhost/KRMuhasebe/public/migrate-bank-transactions.php
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/Helper.php';

$db = Database::getInstance();

echo "<h1>Banka İşlemleri Tablosu Güncelleme</h1>";
echo "<p>account_category kolonu ekleniyor...</p>";

try {
    // Check if column already exists
    $result = $db->select("SHOW COLUMNS FROM bank_transactions LIKE 'account_category'");

    if ($result && count($result) > 0) {
        echo "<div style='color: orange; padding: 10px; border: 1px solid orange; margin: 10px 0;'>";
        echo "⚠️ <strong>account_category</strong> kolonu zaten mevcut.";
        echo "</div>";
    } else {
        // Add column
        $conn = $db->getConnection();
        $conn->exec("
            ALTER TABLE bank_transactions
            ADD COLUMN account_category ENUM('bch', 'kmh', 'installment_loan', 'credit_card') DEFAULT NULL
            AFTER bank_id
        ");

        // Add index
        $conn->exec("
            ALTER TABLE bank_transactions
            ADD INDEX idx_account_category (account_category)
        ");

        echo "<div style='color: green; padding: 10px; border: 1px solid green; margin: 10px 0;'>";
        echo "✅ <strong>account_category</strong> kolonu başarıyla eklendi!<br>";
        echo "✅ Index oluşturuldu!";
        echo "</div>";
    }

    echo "<h2>Mevcut Banka İşlemleri</h2>";
    $transactions = $db->select("SELECT * FROM bank_transactions ORDER BY transaction_date DESC LIMIT 10");

    if (empty($transactions)) {
        echo "<p>Henüz işlem kaydı yok.</p>";
    } else {
        echo "<table border='1' cellpadding='5' cellspacing='0' style='border-collapse: collapse; width: 100%;'>";
        echo "<thead>";
        echo "<tr>";
        echo "<th>ID</th>";
        echo "<th>Banka ID</th>";
        echo "<th>Kategori</th>";
        echo "<th>İşlem Tipi</th>";
        echo "<th>Tutar</th>";
        echo "<th>Tarih</th>";
        echo "</tr>";
        echo "</thead>";
        echo "<tbody>";

        foreach ($transactions as $trans) {
            echo "<tr>";
            echo "<td>{$trans['id']}</td>";
            echo "<td>{$trans['bank_id']}</td>";
            echo "<td>" . ($trans['account_category'] ?? '<em>null</em>') . "</td>";
            echo "<td>{$trans['transaction_type']}</td>";
            echo "<td>" . number_format($trans['amount'], 2) . " ₺</td>";
            echo "<td>{$trans['transaction_date']}</td>";
            echo "</tr>";
        }

        echo "</tbody>";
        echo "</table>";
    }

    echo "<hr>";
    echo "<p><strong>✅ Migration tamamlandı!</strong></p>";
    echo "<p><a href='" . BASE_URL . "/banks'>Bankalar Sayfasına Git</a></p>";

} catch (Exception $e) {
    echo "<div style='color: red; padding: 10px; border: 1px solid red; margin: 10px 0;'>";
    echo "❌ Hata: " . $e->getMessage();
    echo "</div>";
}
?>
