<?php
/**
 * BCH + Taksitli Kredi guncel veri yukleme
 *
 * Calistirma:
 * http://localhost/KRMuhasebe/public/fill-bch-installment-snapshot.php
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../core/Database.php';

$db = Database::getInstance();
$conn = $db->getConnection();

echo "<h1>BCH + Taksitli Kredi Veri Yukleme</h1>";

try {
    $conn->beginTransaction();

    // BCH temizle + ekle
    $conn->exec("DELETE FROM bank_bch");

    $bchRows = [
        ['ZIRAAT BANK-BCH', 0.00, '2026-02-10', 'ÖDEME', '2026-02-10', '300 bin odendi KMH lar ile'],
        ['AKBANK-BCH', 350000.00, '2026-02-18', 'BEKLEMEDE', null, null],
        ['ZIRAAT BANK-BCH', 200000.00, '2026-04-17', 'BEKLEMEDE', null, null],
        ['HALK BANK-BCH', 300000.00, '2026-05-07', 'BEKLEMEDE', null, null],
        ['HALK BANK-BCH', 500000.00, '2026-05-26', 'BEKLEMEDE', null, null],
        ['ZIRAAT BANK-BCH', 100000.00, '2026-05-26', 'BEKLEMEDE', null, null],
        ['HALK BANK-BCH', 575000.00, '2026-06-05', 'BEKLEMEDE', null, null],
        ['ZIRAAT BANK-BCH', 100000.00, '2026-06-12', 'BEKLEMEDE', null, null],
        ['AKBANK-BCH', 350000.00, '2026-06-13', 'BEKLEMEDE', null, null],
    ];

    $insertBch = $conn->prepare("
        INSERT INTO bank_bch (bank_name, amount, due_date, status, payment_date, description)
        VALUES (?, ?, ?, ?, ?, ?)
    ");
    foreach ($bchRows as $row) {
        $insertBch->execute($row);
    }

    // Taksitli kredi temizle + ekle
    $conn->exec("DELETE FROM bank_installment_payments");
    $conn->exec("DELETE FROM bank_installment_loans");

    $loanRows = [
        ['GARANTI BANK', 500000.00, 35427.77, 1, 1, '2026-01-01', '2026-03-01', 'DEVAM EDİYOR', 'Odeme gunu: 1'],
        ['IS BANKASI', 600000.00, 63251.77, 1, 1, '2026-01-01', '2026-03-17', 'DEVAM EDİYOR', 'Odeme gunu: 17'],
        ['ZIRAAT BANK', 500000.00, 59106.73, 1, 1, '2026-01-01', '2026-03-20', 'DEVAM EDİYOR', 'Odeme gunu: 20'],
        ['HALK BANKASI', 850000.00, 56896.20, 1, 1, '2026-01-01', '2026-03-05', 'DEVAM EDİYOR', 'Odeme gunu: 5'],
        ['YAPI KREDI', 500000.00, 31398.79, 1, 1, '2026-01-01', '2026-03-19', 'DEVAM EDİYOR', 'Odeme gunu: 19'],
        ['ZIRAAT BANK', 500000.00, 57783.21, 1, 1, '2026-01-01', '2026-03-10', 'DEVAM EDİYOR', 'Odeme gunu: 10'],
    ];

    $insertLoan = $conn->prepare("
        INSERT INTO bank_installment_loans
        (bank_name, loan_amount, monthly_payment, total_installments, remaining_installments, start_date, next_payment_date, status, description)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    $insertPayment = $conn->prepare("
        INSERT INTO bank_installment_payments
        (loan_id, payment_number, payment_date, amount, status)
        VALUES (?, ?, ?, ?, 'BEKLEMEDE')
    ");
    foreach ($loanRows as $row) {
        $insertLoan->execute($row);
        $loanId = (int)$conn->lastInsertId();
        $insertPayment->execute([$loanId, 1, $row[6], $row[2]]);
    }

    $conn->commit();

    echo "<div style='padding:12px;border:1px solid #198754;color:#198754;margin:10px 0;'>";
    echo "Veriler basariyla guncellendi.";
    echo "</div>";

    $bchTotal = $db->selectOne("SELECT SUM(amount) AS total FROM bank_bch WHERE status = 'BEKLEMEDE'");
    $loanTotal = $db->selectOne("SELECT SUM(loan_amount) AS total_loan, SUM(monthly_payment) AS total_monthly FROM bank_installment_loans");

    echo "<h3>Kontrol Toplamlari</h3>";
    echo "<ul>";
    echo "<li>BCH (beklemede): " . number_format($bchTotal['total'] ?? 0, 2, ',', '.') . " ₺</li>";
    echo "<li>Taksitli kredi toplam tutar: " . number_format($loanTotal['total_loan'] ?? 0, 2, ',', '.') . " ₺</li>";
    echo "<li>Taksitli kredi aylik toplam: " . number_format($loanTotal['total_monthly'] ?? 0, 2, ',', '.') . " ₺</li>";
    echo "</ul>";

    echo "<p><a href='" . BASE_URL . "/banks/bch'>BCH sayfasina git</a></p>";
    echo "<p><a href='" . BASE_URL . "/banks/installment-loans'>Taksitli kredi sayfasina git</a></p>";
} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    echo "<div style='padding:12px;border:1px solid #dc3545;color:#dc3545;margin:10px 0;'>";
    echo "Hata: " . htmlspecialchars($e->getMessage());
    echo "</div>";
}
